# Tales of Popolon (MSX) by Santiago Ontañón Villar

<img src="https://github.com/santiontanon/talesofpopolon/blob/master/graphics/top-cover-small.png?raw=true" alt="cover" width="400"/> 

You can buy a physical copy of the game via: http://www.matranet.net/boutique/msx/card/top/top.php 

Download latest compiled ROMs (v1.3.1) from: https://github.com/santiontanon/talesofpopolon/releases/tag/v1.3.1

You will need an MSX emulator to play the game on a PC, for example OpenMSX: http://openmsx.org

Or you can play directly online (thanks to thf!): http://www.file-hunter.com/MSX/Top.html


## Introduction

For many centuries, the world had been at peace. Lands were prosperous, and people reached old age. However, all of that was about to change...

Suddenly, towns started being attacked by beasts, killing many. Storms started sinking ships into the ocean and ruined crops. People started to think that they had lost the favor of the Gods of Olympus...

In response, one night, Thanatos, the God of peaceful death, appeared in the dreams of the mighty hero Popolon.

Popolon, I am Thanatos! The Gods of Olympus need your help! An Evil fortress has been built in Olympus against our will... Someone is causing people to die, and their souls are being sent to be trapped in the fortress, preventing them from reaching Hades!

You are our only hope Popolon! Only mortal souls can enter the fortress. Please go and stop the source of evil!


## Instructions

Screenshots (of version 1.2):

<img src="https://github.com/santiontanon/talesofpopolon/blob/master/graphics/top-ss1.png?raw=true" alt="title screen" width="400"/> <img src="https://github.com/santiontanon/talesofpopolon/blob/master/graphics/top-ss2.png?raw=true" alt="in game 1" width="400"/>

<img src="https://github.com/santiontanon/talesofpopolon/blob/master/graphics/top-ss3.png?raw=true" alt="in game 2" width="400"/> <img src="https://github.com/santiontanon/talesofpopolon/blob/master/graphics/top-ss4.png?raw=true" alt="in game 3" width="400"/>

You can see a video of the game at: https://youtu.be/u9HiZfxoLmk

In Tales of Popolon you play as Popolon, an ancient Greek hero tasked with a mission from Thanatos. He must discover who is trapping souls of people in an evil fortress built at the base of Mount Olympus and stopping them! You will have to find your way around the labyrinthic fortress, defeating monsters that inhabit it while collecting weapons and other power-ups that are spread over the fortress.

The following screens show the basic elements of the game screen:

<img src="https://github.com/santiontanon/talesofpopolon/blob/master/graphics/top-title-layout.png?raw=true" alt="title screen" width="640"/>
<img src="https://github.com/santiontanon/talesofpopolon/blob/master/graphics/top-screen-layout.png?raw=true" alt="in-game screen" width="640"/>

Pay special attention to:
* Popolon's main weapon: initially, Popolon starts empty handed and thus has a very short range of attack. Make sure you find a sword to increase the attack range.
* Secondary weapon: you will find ranged weapons, such as bows, or other magical weapons that you can use in addition to the main weapon. The secondary weapon uses "God" power each time you use it though. So, make sure you have plenty of it!
* Armor: Popolon starts with an iron armor, but better armors can be collected throughout the game that will block some of the damage.
* Vitality: make sure that it does not reach 0, or Popolon will die! You can replenish vitality by collecting light blue potions.
* God power: collect the blue hearts that some enemies drop when killed in order to increase your God power.
* Keys: throughout the adventure you will find several types of doors. Some of them can only be open by activating some switches, and some others require keys. Make sure to collect all the keys you find.

Additionally, Tales of Popolon lets you change the size of the gameplay viewport. A larger viewport lets you see more of the surroundings, but makes the game run slower. A smaller viewport gives you a more limited view, but makes the game run faster.

Finally, although Thanatos is not allowed to enter the fortress, he will be able to contact you via the stone faces you will find in the game. Some of them will give you a password. Make sure to note it down in order to resume the game exactly at the point where you left it. You can enter this password again from the title screen by pressing M or Trigger B.


## Items

* ![Potion](https://github.com/santiontanon/talesofpopolon/blob/master/graphics/item-potion.png?raw=true): Potions replenish four points of vitality.
* ![Heart](https://github.com/santiontanon/talesofpopolon/blob/master/graphics/item-heart.png?raw=true): Blue hearts give one point of God power.
* ![Key](https://github.com/santiontanon/talesofpopolon/blob/master/graphics/item-key.png?raw=true): Keys let you open yellow doors.
* ![Switch](https://github.com/santiontanon/talesofpopolon/blob/master/graphics/item-switch.png?raw=true): You can activate switches with your main or secondary weapon. Be careful though, if you close a door in the position where Popolon is standing, Popolon will die!
* ![Sword](https://github.com/santiontanon/talesofpopolon/blob/master/graphics/item-sword.png?raw=true): Increases your range of attack.
* ![Gold Sword](https://github.com/santiontanon/talesofpopolon/blob/master/graphics/item-goldsword.png?raw=true): Even longer attack range.
* ![Arrows](https://github.com/santiontanon/talesofpopolon/blob/master/graphics/item-arrows.png?raw=true): Allows you to attack enemies from a distance, each arrow uses one point of God power (notice that some enemies might be able to deflect arrows with their shields though!).
* ![Ice arrows](https://github.com/santiontanon/talesofpopolon/blob/master/graphics/item-icearrows.png?raw=true): Don't do damage, but freeze enemies for some time. Two points of God power are used per ice arrow.
* ![Hourglass](https://github.com/santiontanon/talesofpopolon/blob/master/graphics/item-hourglass.png?raw=true): Stops time, and lets Popolon freely move around enemies without them moving for some seconds. Each use requires four units of God power.


## Controls

Keyboard:
* Left/right arrow keys - rotate Popolon
* Up/down arrow keys    - move forward/backward
* Space                 - use the main weapon / skip text
* Space + Left/right arrow keys - move left/right
* M 					- use the secondary weapon
* 1 					- change your primary weapon
* 2 					- change your secondary weapon
* 3 					- change your armor
* P                     - pause the game
* 0 					- change the gameplay viewport size
* R                     - toggle CPU mode (MSX2+ Turbo R only). There are 3 modes available: Z80 (the same way it runs for other MSX models), R800-smooth (game runs at the same speed, but with smoother movement as the R800 can render twice as many frames per second), and R800-fast (which basically just runs the Z80 code, but at the speed of the R800, and makes the game just go twice as fast).

Joystick:
* Left/right - rotate Popolon
* Up/down    - move forward/backward
* Trigger A  - use the main weapon / skip text
* Trigger A + Left/right - move left/right
* Trigger B  - use the secondary weapon


In the title screen:
* Space/Trigger A to start the game
* M/Trigger B to enter a password


## Compatibility

The game was designed to be played on MSX1 computers with at least 16KB of RAM. I used the Philips VG8020 as the reference machine (since that's the MSX I owned as a kid), but I've tested it in some other machines using OpenMSX v0.13. If you detect an incompatibility, please let me know!

That being said, if the game detects that you are running on a Panasonic MSX2+ with turbo, then turbo will be activated to get 50% more speed. Also, if the game detects you are running it on a Turbo R, the game will switch to the R800 CPU to also take advantage from the extra speed (you can press "R" while playing the game to switch between the different CPU modes in a Turbo R).


## Notes:

Some notes and useful links I used when coding Tales of Popolon

* There is a "build" script in the home folder. Use it to re-build the game from sources.
* Also, Tales of Popolon uses many different data files (graphics/sounds/maps/precalculated tables). Some of those are generated directly from PNG images, and some others are generated by running some Java scripts. You can re-generate those data files by running the "regenerateData" script.
* To measure code execution time I used: http://msx.jannone.org/bit/
* Math routines: http://z80-heaven.wikidot.com/math
* PSG (sound) registers: http://www.angelfire.com/art2/unicorndreams/msx/RR-PSG.html
* Z80 tutotial: http://sgate.emt.bme.hu/patai/publications/z80guide/part1.html
* Z80 user manual (I used this HEAVILY!): http://www.zilog.com/appnotes_download.php?FromPage=DirectLink&dn=UM0080&ft=User%20Manual&f=YUhSMGNEb3ZMM2QzZHk1NmFXeHZaeTVqYjIwdlpHOWpjeTk2T0RBdlZVMHdNRGd3TG5Ca1pnPT0=
* MSX system variables: http://map.grauw.nl/resources/msxsystemvars.php
* MSX bios calls: 
    * http://map.grauw.nl/resources/msxbios.php
    * https://sourceforge.net/p/cbios/cbios/ci/master/tree/
* VDP reference: http://bifi.msxnet.org/msxnet/tech/tms9918a.txt
* VDP manual: http://map.grauw.nl/resources/video/texasinstruments_tms9918.pdf
* The game was compiled with Grauw's Glass compiler (cannot thank him enough for creating it): https://bitbucket.org/grauw/glass
* In order to compress data I used Pletter v0.5b - XL2S Entertainment 2008 (there is a Java port of the Pletter compressor in the Java source code in the repository).
* I am proud of the way the 3d raycasting engine of Tales of Popolon came out, specially given it runs on MSX1 hardware, whose VDP is really not your friend when it comes to 3D graphics. I took inspiration from other 8bit 3D games (with far more impressive rendering engines), such as:
	* Stunt car racer: https://www.youtube.com/watch?v=TPDznD7QHb0
	* Micronaut one: https://www.youtube.com/watch?v=v8gtajpc89s
	* Spectrum Doom (is this real though? I have not seen the sourcecode/binary anywhere, if anyone has it, please let me know!): https://www.youtube.com/watch?v=kW_XDSFdn-4
	* ARTRAG's raycasting demo for MSX2+ Turbo R: https://www.youtube.com/watch?v=8ffvdvpePY8

